/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.quests.condition.AbstractQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProviderSerializer;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionProviderType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class EquipmentConditionProvider
extends AbstractQuestConditionProvider<EquipmentConditionProvider>
implements IQuestCondition {
    private final Map<EquipmentSlotType, Item> map;
    private final String name;
    private final ITextComponent[] descriptors;

    public EquipmentConditionProvider(QuestConditionProviderType<?> type, Map<EquipmentSlotType, Item> map, String name) {
        super(type);
        this.map = map;
        this.name = name;
        this.descriptors = EquipmentConditionProvider.expandWithShortLocalizations(new ITextComponent[]{new TranslationTextComponent(this.getLocalizationString(), new Object[]{name})});
    }

    public static EquipmentConditionProvider fromNbt(QuestConditionProviderType<EquipmentConditionProvider> type, CompoundNBT data) {
        String name = data.func_74779_i("equipment.name");
        ListNBT equipment = data.func_150295_c("equipment", 10);
        EnumMap<EquipmentSlotType, Item> map = new EnumMap<EquipmentSlotType, Item>(EquipmentSlotType.class);
        for (int i = 0; i < equipment.size(); ++i) {
            CompoundNBT tag = equipment.func_150305_b(i);
            EquipmentSlotType slotType = EquipmentSlotType.func_188451_a((String)tag.func_74779_i("slotType"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("item")));
            map.put(slotType, item);
        }
        return new EquipmentConditionProvider(type, map, name);
    }

    @Override
    public boolean isValid(PlayerEntity player, IPropertyReader reader) {
        for (Map.Entry<EquipmentSlotType, Item> entry : this.map.entrySet()) {
            EquipmentSlotType slotType = entry.getKey();
            Item item = entry.getValue();
            ItemStack equipped = player.func_184582_a(slotType);
            if (equipped.func_77973_b() == item) continue;
            return false;
        }
        return true;
    }

    @Override
    public ITextComponent getDescriptor(boolean shortDesc) {
        return this.descriptors[shortDesc ? 1 : 0];
    }

    @Override
    public EquipmentConditionProvider makeConditionInstance() {
        return this;
    }

    @Override
    public IQuestConditionProvider<?> getProviderType() {
        return this;
    }

    @Override
    public void saveInternalData(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (Map.Entry<EquipmentSlotType, Item> entry : this.map.entrySet()) {
            CompoundNBT data = new CompoundNBT();
            EquipmentSlotType slotType = entry.getKey();
            Item item = entry.getValue();
            data.func_74778_a("slotType", slotType.func_188450_d());
            data.func_74778_a("item", item.getRegistryName().toString());
            list.add((Object)data);
        }
        nbt.func_218657_a("equipment", (INBT)list);
        nbt.func_74778_a("equipment.name", this.name);
    }

    public static final class Serializer
    implements IQuestConditionProviderSerializer<EquipmentConditionProvider> {
        @Override
        public EquipmentConditionProvider deserialize(QuestConditionProviderType<EquipmentConditionProvider> conditionType, JsonElement data) {
            JsonObject object = JsonHelper.asJsonObject(data);
            String typeOfEquipment = JSONUtils.func_151200_h((JsonObject)object, (String)"equipmentName");
            JsonObject slots = JSONUtils.func_152754_s((JsonObject)object, (String)"slots");
            EnumMap<EquipmentSlotType, Item> map = new EnumMap<EquipmentSlotType, Item>(EquipmentSlotType.class);
            for (Map.Entry entry : slots.entrySet()) {
                EquipmentSlotType slotType;
                try {
                    slotType = EquipmentSlotType.valueOf((String)((String)entry.getKey()).toUpperCase());
                }
                catch (Exception e) {
                    throw new JsonSyntaxException("Unknown equipment slot: " + (String)entry.getKey());
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(((JsonElement)entry.getValue()).getAsString()));
                map.put(slotType, item);
            }
            return new EquipmentConditionProvider(conditionType, map, typeOfEquipment);
        }
    }
}

